<?php

namespace App\Console\Commands;
use App\Models\NotificationQueue;
use Illuminate\Support\Facades\Http;
use App\Services\NotificationQueueService;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
class SendProgressNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fetch-and-send:progress-notifications';
    protected $description = 'Получает данные о задачах, обновляет очередь уведомлений и отправляет GET-запросы';

    protected $notificationQueueService;

    public function __construct(NotificationQueueService $notificationQueueService)
    {
        parent::__construct();
        $this->notificationQueueService = $notificationQueueService;
    }

    public function handle()
    {
        // Шаг 1: Получаем данные задач (эту функцию вы должны реализовать сами)
        $issues = $this->notificationQueueService->getFilterResult();

        // Шаг 2: Обновляем очередь уведомлений
        $this->notificationQueueService->addOrUpdateNotificationQueue($issues);

        // Шаг 3: Отправляем GET-запросы для уведомлений, запланированных на сегодня
        $this->sendProgressNotifications();
    }

    /**
     * Получает данные задач (реализуйте свою логику для получения задач)
     *
     * @return array
     */

    private function sendProgressNotifications()
    {
        $currentDate = Carbon::now();

        // Находим записи для уведомлений, запланированных на сегодня, и еще не отправленных
        $notifications = NotificationQueue::where('is_notified', false)
            ->whereDate(DB::raw("FROM_UNIXTIME(value / 1000)"), '=', $currentDate)
            ->get();


        foreach ($notifications as $notification) {


            // Формируем GET-запрос на основе прогресса и языка
            $url = $this->generateUrl($notification);

            // Отправляем GET-запрос
            $response = Http::get($url);
            echo $url.PHP_EOL;

            if ($response->successful()) {
                // Обновляем статус уведомления
                $notification->update(['is_notified' => true]);
            }
        }
    }

    /**
     * Формирует URL для GET-запроса на основе прогресса и языка.
     *
     * @param NotificationQueue $notification
     * @return string
     */
    protected function generateUrl($notification)
    {
        $stage = $this->getStageByPercentage($notification->percentage_field_name);
        $language =$this->getLanguageCode($notification->lang);

        // Параметры для GET-запроса
        $params = [
            'action' => 'send_candidate_email',
            'task_id' => $notification->issue_id,
            'language' => $language,
            'stage' => $stage
        ];

        // Базовый URL
        $baseUrl = 'https://demo.aaagameartstudio.com/';

        return $baseUrl . '?' . http_build_query($params);
    }

    /**
     * Возвращает значение `stage` на основе процента.
     *
     * @param string $percentageFieldName
     * @return string
     */
    protected function getStageByPercentage($percentageFieldName)
    {
        $stages = [
            'value_30' => 'thirty',
            'value_60' => 'sixty',
            'value_90' => 'ninety',
            'value_100' => 'hundred',
            'value_100plus' => 'hundredplus'
        ];

        return $stages[$percentageFieldName] ?? 'unknown';
    }
    protected function getLanguageCode($lang)
    {
        $languages = [
            'Русский' => 'ru',
            'English' => 'en',
            'Українська' => 'ua',
        ];

        return $languages[$lang] ?? 'unknown';
    }
}
