<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Определение команд, доступных для приложения.
     *
     * @return void
     */
    protected function commands()
    {
        // Загрузка пользовательских команд из папки Commands
        $this->load(__DIR__ . '/Commands');

        // Вы также можете зарегистрировать команды вручную
        require base_path('routes/console.php');
    }

    /**
     * Определение расписания для команд.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // Пример команды, выполняемой ежедневно
        $schedule->command('fetch-and-send:progress-notifications')->everyMinute();
    }
}
