<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
class IssuesListsController extends Controller
{


    public function getYouTrackIssues()
    {
        // Base URL and API token
        $baseUrl = 'https://aaagamestudio.youtrack.cloud/api/issues';
        $token = 'perm:QUk=.NTktNA==.wbqnH74Ie8g6X3R0zZkOch6bqGUnUb';

        // Headers for authorization
        $headers = [
            'Authorization' => "Bearer $token",
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
        ];

        // Fields to retrieve for each issue
        $fields = '$type,id,idReadable,summary,customFields($type,id,projectCustomField($type,id,field($type,id,name)),value($type,avatarUrl,buildLink,color(id),fullName,id,isResolved,localizedName,login,minutes,name,presentation,text))';

        // Query parameters: search for issues where the field "30%" is not empty
        $query = 'project: Candidates 30%: -{-} updated: Today'; // Replace "30%" with the actual field name if different

        // Send request with Laravel HTTP client
        $response = Http::withHeaders($headers)
            ->get($baseUrl, [
                'fields' => $fields,
                'query' => $query,
            ]);

        // Check for response success and decode JSON
        if ($response->successful()) {
            return $response->json();
        } else {
            // Handle error
            throw new \Exception('Error: ' . $response->body());
        }
    }

    public function index()
  {
        $result = $this->getYouTrackIssues();
        $filter_result = $this->getTasksWithPercentageValue($result);
        dd($filter_result);
  }

    public function getFilterResult()
    {
        $result = $this->getYouTrackIssues();
        $filter_result = $this->getTasksWithPercentageValue($result);
        return $filter_result;
    }

    public function getTasksWithPercentageValue($issues)
    {
        $currentTime = time(); // Текущее время в формате Unix Timestamp
        $filteredIssues = [];

        foreach ($issues as $issue) {
            // Инициализируем массив для хранения полей с процентами
            $percentageValues = [
                'issue_id' => $issue['idReadable'],
                'summary' => $issue['summary'],
            ];

            if (!isset($issue['customFields']) || !is_array($issue['customFields'])) {
                continue;
            }

            foreach ($issue['customFields'] as $field) {
                // Проверяем, что поле имеет название с процентом и значение
                if (isset($field['projectCustomField']['field']['name'], $field['value']) &&
                    preg_match('/(\d+)%/', $field['projectCustomField']['field']['name'], $matches)) {

                    $percent = $matches[1]; // Извлекаем числовое значение процента
                    $fieldKey = "value_{$percent}"; // Генерируем ключ, например, "value_30"

                    // Проверяем, что значение поля >= текущему времени
                    if (is_numeric($field['value']) && $field['value'] >= $currentTime * 1000) {
                        $percentageValues[$fieldKey] = $field['value'];
                    }
                }

                // Проверка на поле "Due Date", которое будет означать "100%"
                if ($field['projectCustomField']['field']['name'] === "Due Date") {
                    $percentageValues['value_100'] = $field['value'];
                }
                if ($field['projectCustomField']['field']['name'] === "Language") {
                    if(isset($field['value']['name'])){
                        $percentageValues['lang'] = $field['value']['name'];
                    }

                }
            }

            // Добавляем задачу в результат только если `value_30` существует и не пусто
            if (!empty($percentageValues['value_30'])) {
                $filteredIssues[] = $percentageValues;
            }
        }

        return $filteredIssues;
    }


}
