<?php
// routes/api.php
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

Route::post('/nft-check', function (Request $request) {
    // Validate the incoming request
    $request->validate([
        'owner_address' => 'required|string',
        'nft_items' => 'required|array',
        'nft_items.*.address' => 'required|string'
    ]);

    // Extract the data from the request
    $walletAddress = $request->input('owner_address');
    $nftItems = $request->input('nft_items');

    // Initialize an array to store the result
    $result = [];

    // Step 1: Make a request to get wallet details
    $walletResponse = Http::get("https://tonapi.io/v2/accounts/{$walletAddress}");

    if (!$walletResponse->successful()) {
        return response()->json(['error' => 'Failed to fetch wallet data'], 500);
    }

    // Extract the address from the wallet response
    $walletData = $walletResponse->json();
    $walletOwnerAddress = $walletData['address'] ?? null;

    if (!$walletOwnerAddress) {
        return response()->json(['error' => 'Wallet address not found'], 500);
    }

    // Step 2: Loop through each NFT item and check the ownership
    foreach ($nftItems as $nftItem) {
        $nftAddress = $nftItem['address'];

        // Fetch the NFT details from the TON API
        $nftResponse = Http::get("https://tonapi.io/v2/nfts/{$nftAddress}");

        if (!$nftResponse->successful()) {
            // If we can't fetch the NFT data, return an error for this NFT
            $result[$nftAddress] = 'Error fetching NFT data';
            continue;
        }

        $nftData = $nftResponse->json();

        // Step 3: Compare the owner addresses
        $nftOwnerAddress = $nftData['owner']['address'] ?? null;
        $isOwnerMatching = ($walletOwnerAddress === $nftOwnerAddress);

        // Store the result for this NFT address
        $result[$nftAddress] = $isOwnerMatching;
    }

    // Step 4: Return the result as a JSON response
    return response()->json($result);
});
